/* JAlbum tool that strips xmp description from files */

Work.on(TreeCollection.of(selectedObjects).parallelStream().filter(ao -> ao.xmpManager != null))
.titled("Strip xmp description")
.inform("This script strips the xmp description from the xmp section of selected files, triggering import from other metadata sources")
.forEach(ao, counter) -> {
	XmpManager mgr = ao.getXmpManager();
	if (mgr.getDescription() != null) {
		mgr.getXMPMeta().deleteProperty(XmpManager.dc_NS, "dc:description");
		mgr.save();
		counter++;
	}
}
.execute(work) -> {
	// Refresh display
	explorer.context.viewFolder(explorer.context.currentFolder);
	window.statusBar.setText("Processed ${work.processed} objects");
}
.showResult();
